unit [!UnitName];

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
[!if=(EcoSpaceUnitName, "<NONE>")]
  Borland.Eco.Handles;
[!else]
  Borland.Eco.Handles, [!EcoSpaceUnitName], [!EcoPackageUnitName];
[!endif]

type
  T[!ClassName] = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  strict protected  
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
  {$ENDREGION}
  strict private
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
// ToDo replace Borland.Eco.Handles.EcoSpace with actual type of ecospace in project
// for fEcoSpace, get_EcoSpace and EcoSpace
[!endif]
    fEcoSpace: [!EcoSpaceClassName];
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: [!EcoSpaceClassName];
    procedure DoneWithEcoSpace;
    property EcoSpace: [!EcoSpaceClassName] read get_EcoSpace;
    {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObjectInstance;
    {$ENDREGION}
    {$REGION 'DataGrid Events'}
    procedure DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    {$endregion}
  public
    procedure DataBind; override;
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure T[!ClassName].InitializeComponent;
begin    
  Include(Self.Load, Self.Page_Load);
  Include(Self.Unload, Self.Page_Unload);
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  //
  // rhRoot
  //
  Self.rhRoot.EcoSpace := nil;
[!if=(EcoSpaceUnitName, "<NONE>")]
[!else]
  Self.rhRoot.EcoSpaceType := TypeOf([!EcoSpaceUnitName].[!EcoSpaceClassName]);
[!endif]
  Self.rhRoot.StaticValueTypeName := '';
  Self.rhRoot.Variables := nil;
end;
{$ENDREGION}

procedure T[!ClassName].Page_Load(sender: System.Object; e: System.EventArgs);
var
  Id: string;
begin
  EcoSpace.Active := True;
  Id := Request.Params['RootId'];
  if Assigned(Id) and (Id <> '') then
    rhRoot.SetElement(ObjectForId(Id));
  if not IsPostBack then
    DataBind;
  // TODO: Put user code to initialize the page here
end;

procedure T[!ClassName].Page_Unload(sender: System.Object; e: System.EventArgs);
begin
  DoneWithEcoSpace();
end;

procedure T[!ClassName].DataBind;
begin
  ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

{$REGION 'Utility Methods'}
procedure T[!ClassName].UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function T[!ClassName].IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function T[!ClassName].ObjectForId(Id: string): IObjectInstance;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

{$REGION 'DataGrid Events'}

// The following code is useful if the form contains a System.Web.UI.Datagrid;
// It assumes that the elementhandle acting as a datasource has
// AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"

procedure T[!ClassName].DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  ToDelete: IObjectInstance;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  ToDelete := ObjectForId(Id);
  if Assigned(ToDelete) then
    ToDelete.Delete;
  UpdateDatabase;
  DataBind;
end;

procedure T[!ClassName].DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := e.Item.ItemIndex;
  DataBind;
end;

procedure T[!ClassName].DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  Row: TObject;
  Eh: ElementHandle;
  ColIndex: Integer;
  Col: BoundColumn;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  SourceGrid.DataBind(); // To set DataSource
  Eh := SourceGrid.DataSource as ElementHandle;
  Row := eh.RenderElement(ObjectForId(Id));
  for colIndex := 0 to SourceGrid.Columns.Count-1 do
  begin
    Col := BoundColumn(SourceGrid.Columns[colIndex]);
    if Assigned(Col) and (not Col.ReadOnly) then
      eh.SetRenderedElementProperty(row, Col.DataField, (e.Item.Cells[colIndex].Controls[0] as TextBox).Text, true);
  end;
  UpdateDatabase;
  SourceGrid.EditItemIndex := -1;
  DataBind;
end;

procedure T[!ClassName].DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := -1;
  DataBind;
end;
{$ENDREGION}

procedure T[!ClassName].OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function T[!ClassName].get_EcoSpace: [!EcoSpaceClassName];
begin
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := TEcoSpaceProvider.GetEcoSpace;
    rhRoot.EcoSpace := fEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure T[!ClassName].DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or its contents here.
  // Otherwise it is not safe to return it to a pool.
  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

end.

